"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomerService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const customer_entity_1 = require("../../entities/customer.entity");
let CustomerService = class CustomerService {
    customerRepo;
    constructor(customerRepo) {
        this.customerRepo = customerRepo;
    }
    toCustomerResponseDto(customer) {
        return {
            id: customer.id,
            name: customer.name,
            email: customer.email,
            phone: customer.phone,
            address: customer.addresses && customer.addresses.length > 0 ? customer.addresses[0].toString() : '',
            createdAt: customer.createdAt,
            updatedAt: customer.updatedAt,
            userId: customer.userId,
        };
    }
    async create(dto) {
        const customer = this.customerRepo.create(dto);
        const savedCustomer = await this.customerRepo.save(customer);
        return this.toCustomerResponseDto(savedCustomer);
    }
    async findAll() {
        const customers = await this.customerRepo.find({
            relations: ['user', 'addresses', 'cart'],
        });
        return customers.map(customer => this.toCustomerResponseDto(customer));
    }
    async findOne(id) {
        const customer = await this.customerRepo.findOne({
            where: { id: Number(id) },
            relations: ['user', 'addresses', 'cart'],
        });
        if (!customer)
            throw new common_1.NotFoundException(`Customer with ID ${id} not found`);
        return this.toCustomerResponseDto(customer);
    }
    async findByEmail(email) {
        const customer = await this.customerRepo.findOne({
            where: { email },
            relations: ['user', 'addresses', 'cart'],
        });
        if (!customer)
            throw new common_1.NotFoundException(`Customer with email ${email} not found`);
        return this.toCustomerResponseDto(customer);
    }
    async findEntityByEmail(email) {
        return await this.customerRepo.findOne({
            where: { email },
            relations: ['user', 'addresses', 'cart'],
        });
    }
    async update(id, dto) {
        const customer = await this.customerRepo.findOne({ where: { id: Number(id) } });
        if (!customer)
            throw new common_1.NotFoundException(`Customer with ID ${id} not found`);
        Object.assign(customer, dto);
        const updated = await this.customerRepo.save(customer);
        return this.toCustomerResponseDto(updated);
    }
    async remove(id) {
        const result = await this.customerRepo.delete(Number(id));
        if (result.affected === 0) {
            throw new common_1.NotFoundException(`Customer with ID ${id} not found`);
        }
    }
    async getProfile(customerId) {
        return this.findOne(customerId);
    }
    async updateProfile(customerId, dto) {
        return this.update(customerId, dto);
    }
    async findByPhone(phone) {
        return this.findOne(phone);
    }
};
exports.CustomerService = CustomerService;
exports.CustomerService = CustomerService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(customer_entity_1.Customer)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], CustomerService);
//# sourceMappingURL=customer.service.js.map